/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_Product;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.X_PP_Product_BOMLine;
import org.idempiere.cache.ImmutablePOSupport;

public class MPPProductBOMLine
extends X_PP_Product_BOMLine
implements ImmutablePOSupport {
    private static final long serialVersionUID = 5942313871247489972L;
    protected MPPProductBOM m_bom = null;

    public static List<MPPProductBOMLine> getByProduct(MProduct product) {
        return new Query(product.getCtx(), "PP_Product_BOMLine", "M_Product_ID=?", product.get_TrxName()).setParameters(product.getM_Product_ID()).setOnlyActiveRecords(true).setClient_ID().list();
    }

    public static MPPProductBOMLine[] getBOMLines(MProduct product) {
        String whereClause = "PP_Product_BOM_ID IN ( SELECT PP_PRODUCT_BOM_ID FROM PP_PRODUCT_BOM WHERE M_PRODUCT_ID = " + product.getM_Product_ID() + " AND IsActive='Y' AND BOMType='A' AND BOMUse='A'  AND AD_Client_ID=" + product.getAD_Client_ID() + ")";
        List<MPPProductBOMLine> list = new Query(product.getCtx(), "PP_Product_BOMLine", whereClause, product.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").list();
        MPPProductBOMLine[] retValue = new MPPProductBOMLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPPProductBOMLine(Properties ctx, String PP_Product_BOMLine_UU, String trxName) {
        super(ctx, PP_Product_BOMLine_UU, trxName);
    }

    public MPPProductBOMLine(Properties ctx, int PP_Product_BOMLine, String trxName) {
        super(ctx, PP_Product_BOMLine, trxName);
    }

    public MPPProductBOMLine(MPPProductBOM bom) {
        super(bom.getCtx(), 0, bom.get_TrxName());
        if (bom.get_ID() <= 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
    }

    public MPPProductBOMLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPProductBOMLine(MPPProductBOMLine copy) {
        this(Env.getCtx(), copy);
    }

    public MPPProductBOMLine(Properties ctx, MPPProductBOMLine copy) {
        this(ctx, copy, null);
    }

    public MPPProductBOMLine(Properties ctx, MPPProductBOMLine copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_bom = copy.m_bom != null ? new MPPProductBOM(ctx, copy.m_bom, trxName) : null;
    }

    public MPPProductBOMLine(Properties ctx, int PP_Product_BOMLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, PP_Product_BOMLine_ID, trxName, virtualColumns);
    }

    public int getLowLevel() {
        I_M_Product parent = this.getPP_Product_BOM().getM_Product();
        if (parent.getLowLevel() > 0) {
            return parent.getLowLevel() + 1;
        }
        return 1;
    }

    public MPPProductBOM getParent() {
        if (this.m_bom == null) {
            this.m_bom = new MPPProductBOM(this.getCtx(), this.getPP_Product_BOM_ID(), this.get_TrxName());
        }
        return this.m_bom;
    }

    public MProduct getProduct() {
        return MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
    }

    public static int getLowLevel(Properties ctx, int M_Product_ID, String trxName) {
        return MProduct.get(ctx, M_Product_ID, trxName).getLowLevel();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isCoProduct() && this.getQty(false).signum() >= 0) {
            throw new AdempiereException("@Qty@ > 0");
        }
        if (this.getLine() <= 0) {
            int line = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0) + 10 FROM PP_Product_BOMLine WHERE PP_Product_BOM_ID=?", this.getPP_Product_BOM_ID());
            this.setLine(line);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MPPProductBOM defaultBOM;
        MPPProductBOM bom;
        MProduct parentProduct;
        MProduct product;
        if (!success) {
            return false;
        }
        int lowlevel = this.getLowLevel();
        if (lowlevel > (product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName())).getLowLevel()) {
            product.setLowLevel(lowlevel);
            product.saveEx();
        }
        if ((parentProduct = (MProduct)(bom = this.getParent()).getM_Product()).isVerified() && (defaultBOM = MPPProductBOM.getDefault(parentProduct, this.get_TrxName())) != null && defaultBOM.getPP_Product_BOM_ID() == bom.getPP_Product_BOM_ID()) {
            if (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("IsActive") && this.isActive()) {
                parentProduct.setIsVerified(false);
                parentProduct.saveEx(this.get_TrxName());
            }
            if (parentProduct.isVerified() && this.is_ValueChanged("IsActive") && !this.isActive()) {
                MPPProductBOMLine[] lines = bom.getLines(true);
                int count = 0;
                MPPProductBOMLine[] mPPProductBOMLineArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    MPPProductBOMLine line = mPPProductBOMLineArray[n2];
                    if (line.getPP_Product_BOMLine_ID() != this.getPP_Product_BOMLine_ID() && line.isActive()) {
                        ++count;
                    }
                    ++n2;
                }
                if (count == 0) {
                    parentProduct.setIsVerified(false);
                    parentProduct.saveEx(this.get_TrxName());
                }
            }
        }
        return true;
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    public boolean isByProduct() {
        String componentType = this.getComponentType();
        return "BY".equals(componentType);
    }

    public boolean isCoProduct() {
        String componentType = this.getComponentType();
        return "CP".equals(componentType);
    }

    public BigDecimal getQty(boolean includeScrapQty) {
        int precision = this.getPrecision();
        BigDecimal qty = this.isQtyPercentage() ? this.getQtyBatch().divide(Env.ONEHUNDRED, precision += 2, RoundingMode.HALF_UP) : this.getQtyBOM();
        if (includeScrapQty) {
            BigDecimal scrapDec = this.getScrap().divide(Env.ONEHUNDRED, 12, RoundingMode.UP);
            qty = qty.divide(Env.ONE.subtract(scrapDec), precision, RoundingMode.HALF_UP);
        }
        if (qty.scale() > precision) {
            qty = qty.setScale(precision, RoundingMode.HALF_UP);
        }
        return qty;
    }

    public BigDecimal getQty() {
        return this.getQty(false);
    }

    public int getPrecision() {
        return MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
    }

    public BigDecimal getCostAllocationPerc(boolean fallback) {
        BigDecimal qty;
        BigDecimal allocationPercent = super.getCostAllocationPerc();
        if (allocationPercent.signum() != 0) {
            return allocationPercent;
        }
        if (fallback && (qty = this.getQty(false).negate()).signum() != 0) {
            allocationPercent = Env.ONE.divide(qty, 4, RoundingMode.HALF_UP);
        }
        return allocationPercent;
    }

    @Override
    public MPPProductBOMLine markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

